import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Set up the figure and axis
fig, ax = plt.subplots(figsize=(6, 9))
ax.set_xlim(0, 4)
ax.set_ylim(0, 6)
ax.set_aspect('equal')
ax.axis('off')

# Colors for pieces and status
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'lightgrey'
}

# Add grid cells
for row in range(6):
    for col in range(4):
        position = f'f{row}-{col}f'
        if ((row == 5) or (row == 4) or (row == 3 and col in [2, 3]) or
            (row == 2 and col in [1, 3]) or (row == 1 and col == 3) or
            (row == 0 and col in [1, 2, 3])):
            # Clear positions
            rect = patches.Rectangle((col, row), 1, 1, linewidth=1, edgecolor='black', facecolor=colors['clear'])
            ax.add_patch(rect)
            ax.text(col + 0.5, row + 0.5, f'{position}\nclr', ha='center', va='center', fontsize=8, color='black')

# Add pieces
# rightl0 piece
rightl0_positions = [(0, 3), (1, 3), (0, 2)]
for (col, row) in rightl0_positions:
    rect = patches.Rectangle((col, row), 1, 1, linewidth=2, edgecolor='black', facecolor=colors['rightl0'])
    ax.add_patch(rect)
    ax.text(col + 0.5, row + 0.7, 'rightl0', ha='center', va='center', fontsize=8, color='white')
    ax.text(col + 0.5, row + 0.4, 'occ', ha='center', va='center', fontsize=8, color='white')

# rightl1 piece
rightl1_positions = [(0, 1), (1, 1), (0, 0)]
for (col, row) in rightl1_positions:
    rect = patches.Rectangle((col, row), 1, 1, linewidth=2, edgecolor='black', facecolor=colors['rightl1'])
    ax.add_patch(rect)
    ax.text(col + 0.5, row + 0.7, 'rightl1', ha='center', va='center', fontsize=8, color='white')
    ax.text(col + 0.5, row + 0.4, 'occ', ha='center', va='center', fontsize=8, color='white')

# square0 piece
square0_position = (2, 1)
rect = patches.Rectangle(square0_position, 1, 1, linewidth=2, edgecolor='black', facecolor=colors['square0'])
ax.add_patch(rect)
ax.text(square0_position[0] + 0.5, square0_position[1] + 0.7, 'square0', ha='center', va='center', fontsize=8, color='white')
ax.text(square0_position[0] + 0.5, square0_position[1] + 0.4, 'occ', ha='center', va='center', fontsize=8, color='white')

# square1 piece
square1_position = (2, 2)
rect = patches.Rectangle(square1_position, 1, 1, linewidth=2, edgecolor='black', facecolor=colors['square1'])
ax.add_patch(rect)
ax.text(square1_position[0] + 0.5, square1_position[1] + 0.7, 'square1', ha='center', va='center', fontsize=8, color='black')
ax.text(square1_position[0] + 0.5, square1_position[1] + 0.4, 'occ', ha='center', va='center', fontsize=8, color='black')

# Legend
legend_elements = [
    patches.Patch(facecolor=colors['rightl0'], edgecolor='black', label='rightl0 (occ)'),
    patches.Patch(facecolor=colors['rightl1'], edgecolor='black', label='rightl1 (occ)'),
    patches.Patch(facecolor=colors['square0'], edgecolor='black', label='square0 (occ)'),
    patches.Patch(facecolor=colors['square1'], edgecolor='black', label='square1 (occ)'),
    patches.Patch(facecolor=colors['clear'], edgecolor='black', label='Clear (clr)')
]
ax.legend(handles=legend_elements, loc='upper right', fontsize=8)

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_27.png', bbox_inches='tight')
plt.close(fig)